"get.samples.names" = function(foldername){
  files = list.files(foldername,pattern=".[Cc][Ss][Vv]$", recursive = TRUE, full.name= TRUE)
  samples.names = gsub("\\.[^.]*$", "",basename(files))
  samples.names
}

get.treatments = function(sample.names){
  treatments = gsub("var","", sample.names)
  treatments = gsub("gli","glu",treatments)
  treatments = gsub("sacarose","sucrose", treatments)
  treatments = gsub("sac","suc", treatments)
  treatments
}

get.glutamine = function(samples.names){
  have.glutamine = grepl("glut", samples.names)
  glutamine = c()
  for (i in 1:length(samples.names)){
    if (have.glutamine[i]){
      glutamine[i] = "glutamina"
    } else {
      glutamine[i] = "sem.glutamina"
    }
  }
  glutamine
}

get.metadata = function(foldername, write.file = TRUE, file.name = "metadata.csv"){
  samples.names = get.samples.names(foldername)
  treatments = get.treatments(samples.names)
  glutamine = get.glutamine(samples.names)
  metadata = data.frame(sample = samples.names, treatment = treatments, glutamine = glutamine)
  if (write.file) write.csv(metadata, file.name, row.names = FALSE)
}
